/*
 * Permissions.cpp
 *
 *  Created on: 05.02.2010
 *      Author: stefan.detter
 */

#include "Permissions.h"
#include <def.h>

#include <QCryptographicHash>

Permissions		Permissions::m_permissions;
Permissions*	Permissions::d = &Permissions::m_permissions;

Permissions::Permissions()
{
    m_passwords.insert( /*trace123*/        "3e6dd902d25ef310259f2f221155b8f37608cf35", QSet<PERMISSION_ID>() << TRACE_ENABLED);
    m_passwords.insert( /*bootloader123*/   "b4ebeb9a85ec2c01f69295d86a1d929e60431613", QSet<PERMISSION_ID>() << READER_UPDATE_BOOTLOADER);

    m_passwords.insert( /*Sugumo60*/        "9a68c6644748b1e2c6d833128ed287e6b8de5f04", QSet<PERMISSION_ID>() << SHOW_WILDCARD_ALL_FIRMWARE_FILES);
    m_passwords.insert( /*Awpinal6_HID*/    "92a471e92580a9929d2d81a114f3afd9c3942e77", QSet<PERMISSION_ID>() << SHOW_WILDCARD_PUR_HID_KEYBOARD_FIRMWARE_FILES);
    m_passwords.insert( /*Otwaom46_IDTRONIC*/       "d5049c765a6f5103005a90dd1885f6d9bd246dc2", QSet<PERMISSION_ID>() << SHOW_WILDCARD_PUR_IDTRONIC_RUSSIA_FIRMWARE_FILES);

#if ENGINEERING_MODE_ALLOWED
    m_passwords.insert( /*Pupoku58*/        "675fed90337717f746339283f4a87346869c85c6", QSet<PERMISSION_ID>() << READER_FREQUENCY_UNLIMITED);
    m_passwords.insert( /*Futete70*/        "1b216378855a9ee2616ca8392450595826eff9b8", QSet<PERMISSION_ID>() << READER_ENGINEERING << TAG_ENGINEERING);
    m_passwords.insert( /*Kubavi85*/        "587b1d3e163d1dfffd334e57a401ed9163871844", QSet<PERMISSION_ID>() << READER_LAB_FUNCTIONS);
    m_passwords.insert( /*Galaha74*/        "71d6ba115497f3a13217cdbbce53334f4a4ed808", QSet<PERMISSION_ID>() << READER_HIDDEN_SETTINGS);
    m_passwords.insert( /*Dutefi25*/        "a8d0658dc2ddf0992ded60919e215cf923013bed", QSet<PERMISSION_ID>() << READER_INTERFACE_SETTINGS);
    m_passwords.insert( /*Latapi71*/        "f70921dd8a9bb98f1ac28aae519660fe634ac21f", QSet<PERMISSION_ID>() << READER_RFP_SETTINGS);
    m_passwords.insert( /*Noneki16*/        "fb67a840c75afb95df08e25a579ea6262ef115fc", QSet<PERMISSION_ID>() << READER_ADVANCED_SETTINGS);
    m_passwords.insert( /*Kuwone25*/        "4fd4004f0254130b0b082da554a5d17e50db5a20", QSet<PERMISSION_ID>() << READER_FREQUENCY_UNLIMITED << READER_ENGINEERING << READER_LAB_FUNCTIONS << READER_HIDDEN_SETTINGS << READER_RFP_SETTINGS << READER_INTERFACE_SETTINGS << READER_ADVANCED_SETTINGS << TAG_ENGINEERING << READER_UPDATE_BOOTLOADER);
#endif

}

Permissions::~Permissions()
{
}


bool Permissions::activatePermission ( const QString& password )
{
	bool success = false;
	QCryptographicHash hash(QCryptographicHash::Sha1);
	hash.addData(password.toLatin1());
	QString hashStr = hash.result().toHex();

	if(m_passwords.contains(hashStr))
	{
		success = true;
		m_permissionFlags += m_passwords.value(hashStr);
	}

	if(success)
		emit permissionsChanged();

	return success;
}


bool Permissions::showWildcardAllFirmwareFiles()
{
	return m_permissionFlags.contains(SHOW_WILDCARD_ALL_FIRMWARE_FILES);
}

bool Permissions::showWildcardPurHIDKeyboardFirmwareFiles()
{
	return m_permissionFlags.contains(SHOW_WILDCARD_PUR_HID_KEYBOARD_FIRMWARE_FILES);
}

bool Permissions::showWildcardPurIdtronicRussiaFirmwareFiles()
{
    return m_permissionFlags.contains(SHOW_WILDCARD_PUR_IDTRONIC_RUSSIA_FIRMWARE_FILES);
}



bool Permissions::traceEnabled()
{
	return m_permissionFlags.contains(TRACE_ENABLED);
}



bool Permissions::readerUpdateBootloader()
{
	return m_permissionFlags.contains(READER_UPDATE_BOOTLOADER);
}


bool Permissions::readerFrequencyUnlimited()
{
	return m_permissionFlags.contains(READER_FREQUENCY_UNLIMITED);
}


bool Permissions::readerAnyEngineering()
{
    return (readerEngineering() || readerHiddenSettings() || readerLabFunctions() || readerInterfaceSettings() || readerReflectedPowerSettings() || readerAdvancedSettings());
}

bool Permissions::readerEngineering ()
{
	return m_permissionFlags.contains(READER_ENGINEERING);
}

bool Permissions::readerHiddenSettings ()
{
	return m_permissionFlags.contains(READER_HIDDEN_SETTINGS);
}

bool Permissions::readerLabFunctions ()
{
	return m_permissionFlags.contains(READER_LAB_FUNCTIONS);
}

bool Permissions::readerInterfaceSettings()
{
    return m_permissionFlags.contains(READER_INTERFACE_SETTINGS);
}

bool Permissions::readerReflectedPowerSettings()
{
    return m_permissionFlags.contains(READER_RFP_SETTINGS);
}

bool Permissions::readerAdvancedSettings ()
{
	return m_permissionFlags.contains(READER_ADVANCED_SETTINGS);
}



bool Permissions::tagEngineering ()
{
	return m_permissionFlags.contains(READER_ENGINEERING);
}



